require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__LINUX_KVM_S390_H)) {
    eval 'sub __LINUX_KVM_S390_H () {1;}' unless defined(&__LINUX_KVM_S390_H);
    require 'linux/types.ph';
    eval 'sub __KVM_S390 () {1;}' unless defined(&__KVM_S390);
    eval 'sub KVM_S390_CMMA_PEEK () {(1<< 0);}' unless defined(&KVM_S390_CMMA_PEEK);
    eval 'sub KVM_S390_RESET_POR () {1;}' unless defined(&KVM_S390_RESET_POR);
    eval 'sub KVM_S390_RESET_CLEAR () {2;}' unless defined(&KVM_S390_RESET_CLEAR);
    eval 'sub KVM_S390_RESET_SUBSYSTEM () {4;}' unless defined(&KVM_S390_RESET_SUBSYSTEM);
    eval 'sub KVM_S390_RESET_CPU_INIT () {8;}' unless defined(&KVM_S390_RESET_CPU_INIT);
    eval 'sub KVM_S390_RESET_IPL () {16;}' unless defined(&KVM_S390_RESET_IPL);
    eval 'sub KVM_S390_MEMOP_LOGICAL_READ () {0;}' unless defined(&KVM_S390_MEMOP_LOGICAL_READ);
    eval 'sub KVM_S390_MEMOP_LOGICAL_WRITE () {1;}' unless defined(&KVM_S390_MEMOP_LOGICAL_WRITE);
    eval 'sub KVM_S390_MEMOP_SIDA_READ () {2;}' unless defined(&KVM_S390_MEMOP_SIDA_READ);
    eval 'sub KVM_S390_MEMOP_SIDA_WRITE () {3;}' unless defined(&KVM_S390_MEMOP_SIDA_WRITE);
    eval 'sub KVM_S390_MEMOP_ABSOLUTE_READ () {4;}' unless defined(&KVM_S390_MEMOP_ABSOLUTE_READ);
    eval 'sub KVM_S390_MEMOP_ABSOLUTE_WRITE () {5;}' unless defined(&KVM_S390_MEMOP_ABSOLUTE_WRITE);
    eval 'sub KVM_S390_MEMOP_ABSOLUTE_CMPXCHG () {6;}' unless defined(&KVM_S390_MEMOP_ABSOLUTE_CMPXCHG);
    eval 'sub KVM_S390_MEMOP_F_CHECK_ONLY () {(1 << 0);}' unless defined(&KVM_S390_MEMOP_F_CHECK_ONLY);
    eval 'sub KVM_S390_MEMOP_F_INJECT_EXCEPTION () {(1 << 1);}' unless defined(&KVM_S390_MEMOP_F_INJECT_EXCEPTION);
    eval 'sub KVM_S390_MEMOP_F_SKEY_PROTECTION () {(1 << 2);}' unless defined(&KVM_S390_MEMOP_F_SKEY_PROTECTION);
    eval 'sub KVM_S390_MEMOP_EXTENSION_CAP_BASE () {(1<< 0);}' unless defined(&KVM_S390_MEMOP_EXTENSION_CAP_BASE);
    eval 'sub KVM_S390_MEMOP_EXTENSION_CAP_CMPXCHG () {(1<< 1);}' unless defined(&KVM_S390_MEMOP_EXTENSION_CAP_CMPXCHG);
    eval 'sub KVM_S390_SIGP_STOP () {0xfffe0000;}' unless defined(&KVM_S390_SIGP_STOP);
    eval 'sub KVM_S390_PROGRAM_INT () {0xfffe0001;}' unless defined(&KVM_S390_PROGRAM_INT);
    eval 'sub KVM_S390_SIGP_SET_PREFIX () {0xfffe0002;}' unless defined(&KVM_S390_SIGP_SET_PREFIX);
    eval 'sub KVM_S390_RESTART () {0xfffe0003;}' unless defined(&KVM_S390_RESTART);
    eval 'sub KVM_S390_INT_PFAULT_INIT () {0xfffe0004;}' unless defined(&KVM_S390_INT_PFAULT_INIT);
    eval 'sub KVM_S390_INT_PFAULT_DONE () {0xfffe0005;}' unless defined(&KVM_S390_INT_PFAULT_DONE);
    eval 'sub KVM_S390_MCHK () {0xfffe1000;}' unless defined(&KVM_S390_MCHK);
    eval 'sub KVM_S390_INT_CLOCK_COMP () {0xffff1004;}' unless defined(&KVM_S390_INT_CLOCK_COMP);
    eval 'sub KVM_S390_INT_CPU_TIMER () {0xffff1005;}' unless defined(&KVM_S390_INT_CPU_TIMER);
    eval 'sub KVM_S390_INT_VIRTIO () {0xffff2603;}' unless defined(&KVM_S390_INT_VIRTIO);
    eval 'sub KVM_S390_INT_SERVICE () {0xffff2401;}' unless defined(&KVM_S390_INT_SERVICE);
    eval 'sub KVM_S390_INT_EMERGENCY () {0xffff1201;}' unless defined(&KVM_S390_INT_EMERGENCY);
    eval 'sub KVM_S390_INT_EXTERNAL_CALL () {0xffff1202;}' unless defined(&KVM_S390_INT_EXTERNAL_CALL);
    eval 'sub KVM_S390_INT_IO {
        my($ai,$cssid,$ssid,$schid) = @_;
	    eval q(((($schid)) | (($ssid) << 16) | (($cssid) << 18) | (($ai) << 26)));
    }' unless defined(&KVM_S390_INT_IO);
    eval 'sub KVM_S390_INT_IO_MIN () {0x;}' unless defined(&KVM_S390_INT_IO_MIN);
    eval 'sub KVM_S390_INT_IO_MAX () {0xfffdffff;}' unless defined(&KVM_S390_INT_IO_MAX);
    eval 'sub KVM_S390_INT_IO_AI_MASK () {0x4000000;}' unless defined(&KVM_S390_INT_IO_AI_MASK);
    eval 'sub KVM_S390_PGM_FLAGS_ILC_VALID () {0x1;}' unless defined(&KVM_S390_PGM_FLAGS_ILC_VALID);
    eval 'sub KVM_S390_PGM_FLAGS_ILC_0 () {0x2;}' unless defined(&KVM_S390_PGM_FLAGS_ILC_0);
    eval 'sub KVM_S390_PGM_FLAGS_ILC_1 () {0x4;}' unless defined(&KVM_S390_PGM_FLAGS_ILC_1);
    eval 'sub KVM_S390_PGM_FLAGS_ILC_MASK () {0x6;}' unless defined(&KVM_S390_PGM_FLAGS_ILC_MASK);
    eval 'sub KVM_S390_PGM_FLAGS_NO_REWIND () {0x8;}' unless defined(&KVM_S390_PGM_FLAGS_NO_REWIND);
    eval 'sub KVM_S390_STOP_FLAG_STORE_STATUS () {0x1;}' unless defined(&KVM_S390_STOP_FLAG_STORE_STATUS);
    eval("sub KVM_PV_DUMP_INIT () { 0; }") unless defined(&KVM_PV_DUMP_INIT);
    eval("sub KVM_PV_DUMP_CONFIG_STOR_STATE () { 1; }") unless defined(&KVM_PV_DUMP_CONFIG_STOR_STATE);
    eval("sub KVM_PV_DUMP_COMPLETE () { 2; }") unless defined(&KVM_PV_DUMP_COMPLETE);
    eval("sub KVM_PV_DUMP_CPU () { 3; }") unless defined(&KVM_PV_DUMP_CPU);
    eval("sub KVM_PV_INFO_VM () { 0; }") unless defined(&KVM_PV_INFO_VM);
    eval("sub KVM_PV_INFO_DUMP () { 1; }") unless defined(&KVM_PV_INFO_DUMP);
    eval("sub KVM_PV_ENABLE () { 0; }") unless defined(&KVM_PV_ENABLE);
    eval("sub KVM_PV_DISABLE () { 1; }") unless defined(&KVM_PV_DISABLE);
    eval("sub KVM_PV_SET_SEC_PARMS () { 2; }") unless defined(&KVM_PV_SET_SEC_PARMS);
    eval("sub KVM_PV_UNPACK () { 3; }") unless defined(&KVM_PV_UNPACK);
    eval("sub KVM_PV_VERIFY () { 4; }") unless defined(&KVM_PV_VERIFY);
    eval("sub KVM_PV_PREP_RESET () { 5; }") unless defined(&KVM_PV_PREP_RESET);
    eval("sub KVM_PV_UNSHARE_ALL () { 6; }") unless defined(&KVM_PV_UNSHARE_ALL);
    eval("sub KVM_PV_INFO () { 7; }") unless defined(&KVM_PV_INFO);
    eval("sub KVM_PV_DUMP () { 8; }") unless defined(&KVM_PV_DUMP);
    eval("sub KVM_PV_ASYNC_CLEANUP_PREPARE () { 9; }") unless defined(&KVM_PV_ASYNC_CLEANUP_PREPARE);
    eval("sub KVM_PV_ASYNC_CLEANUP_PERFORM () { 10; }") unless defined(&KVM_PV_ASYNC_CLEANUP_PERFORM);
    eval 'sub KVM_S390_ZPCIOP_REG_AEN () {0;}' unless defined(&KVM_S390_ZPCIOP_REG_AEN);
    eval 'sub KVM_S390_ZPCIOP_DEREG_AEN () {1;}' unless defined(&KVM_S390_ZPCIOP_DEREG_AEN);
    eval 'sub KVM_S390_ZPCIOP_REGAEN_HOST () {(1<< 0);}' unless defined(&KVM_S390_ZPCIOP_REGAEN_HOST);
    eval 'sub KVM_DEV_FLIC_GET_ALL_IRQS () {1;}' unless defined(&KVM_DEV_FLIC_GET_ALL_IRQS);
    eval 'sub KVM_DEV_FLIC_ENQUEUE () {2;}' unless defined(&KVM_DEV_FLIC_ENQUEUE);
    eval 'sub KVM_DEV_FLIC_CLEAR_IRQS () {3;}' unless defined(&KVM_DEV_FLIC_CLEAR_IRQS);
    eval 'sub KVM_DEV_FLIC_APF_ENABLE () {4;}' unless defined(&KVM_DEV_FLIC_APF_ENABLE);
    eval 'sub KVM_DEV_FLIC_APF_DISABLE_WAIT () {5;}' unless defined(&KVM_DEV_FLIC_APF_DISABLE_WAIT);
    eval 'sub KVM_DEV_FLIC_ADAPTER_REGISTER () {6;}' unless defined(&KVM_DEV_FLIC_ADAPTER_REGISTER);
    eval 'sub KVM_DEV_FLIC_ADAPTER_MODIFY () {7;}' unless defined(&KVM_DEV_FLIC_ADAPTER_MODIFY);
    eval 'sub KVM_DEV_FLIC_CLEAR_IO_IRQ () {8;}' unless defined(&KVM_DEV_FLIC_CLEAR_IO_IRQ);
    eval 'sub KVM_DEV_FLIC_AISM () {9;}' unless defined(&KVM_DEV_FLIC_AISM);
    eval 'sub KVM_DEV_FLIC_AIRQ_INJECT () {10;}' unless defined(&KVM_DEV_FLIC_AIRQ_INJECT);
    eval 'sub KVM_DEV_FLIC_AISM_ALL () {11;}' unless defined(&KVM_DEV_FLIC_AISM_ALL);
    eval 'sub KVM_S390_MAX_FLOAT_IRQS () {266250;}' unless defined(&KVM_S390_MAX_FLOAT_IRQS);
    eval 'sub KVM_S390_FLIC_MAX_BUFFER () {0x2000000;}' unless defined(&KVM_S390_FLIC_MAX_BUFFER);
    eval 'sub KVM_S390_ADAPTER_SUPPRESSIBLE () {0x1;}' unless defined(&KVM_S390_ADAPTER_SUPPRESSIBLE);
    eval 'sub KVM_S390_IO_ADAPTER_MASK () {1;}' unless defined(&KVM_S390_IO_ADAPTER_MASK);
    eval 'sub KVM_S390_IO_ADAPTER_MAP () {2;}' unless defined(&KVM_S390_IO_ADAPTER_MAP);
    eval 'sub KVM_S390_IO_ADAPTER_UNMAP () {3;}' unless defined(&KVM_S390_IO_ADAPTER_UNMAP);
    eval 'sub KVM_S390_VM_MEM_CTRL () {0;}' unless defined(&KVM_S390_VM_MEM_CTRL);
    eval 'sub KVM_S390_VM_TOD () {1;}' unless defined(&KVM_S390_VM_TOD);
    eval 'sub KVM_S390_VM_CRYPTO () {2;}' unless defined(&KVM_S390_VM_CRYPTO);
    eval 'sub KVM_S390_VM_CPU_MODEL () {3;}' unless defined(&KVM_S390_VM_CPU_MODEL);
    eval 'sub KVM_S390_VM_MIGRATION () {4;}' unless defined(&KVM_S390_VM_MIGRATION);
    eval 'sub KVM_S390_VM_CPU_TOPOLOGY () {5;}' unless defined(&KVM_S390_VM_CPU_TOPOLOGY);
    eval 'sub KVM_S390_VM_MEM_ENABLE_CMMA () {0;}' unless defined(&KVM_S390_VM_MEM_ENABLE_CMMA);
    eval 'sub KVM_S390_VM_MEM_CLR_CMMA () {1;}' unless defined(&KVM_S390_VM_MEM_CLR_CMMA);
    eval 'sub KVM_S390_VM_MEM_LIMIT_SIZE () {2;}' unless defined(&KVM_S390_VM_MEM_LIMIT_SIZE);
    eval 'sub KVM_S390_NO_MEM_LIMIT () { &U64_MAX;}' unless defined(&KVM_S390_NO_MEM_LIMIT);
    eval 'sub KVM_S390_VM_TOD_LOW () {0;}' unless defined(&KVM_S390_VM_TOD_LOW);
    eval 'sub KVM_S390_VM_TOD_HIGH () {1;}' unless defined(&KVM_S390_VM_TOD_HIGH);
    eval 'sub KVM_S390_VM_TOD_EXT () {2;}' unless defined(&KVM_S390_VM_TOD_EXT);
    eval 'sub KVM_S390_VM_CPU_PROCESSOR () {0;}' unless defined(&KVM_S390_VM_CPU_PROCESSOR);
    eval 'sub KVM_S390_VM_CPU_MACHINE () {1;}' unless defined(&KVM_S390_VM_CPU_MACHINE);
    eval 'sub KVM_S390_VM_CPU_PROCESSOR_FEAT () {2;}' unless defined(&KVM_S390_VM_CPU_PROCESSOR_FEAT);
    eval 'sub KVM_S390_VM_CPU_MACHINE_FEAT () {3;}' unless defined(&KVM_S390_VM_CPU_MACHINE_FEAT);
    eval 'sub KVM_S390_VM_CPU_FEAT_NR_BITS () {1024;}' unless defined(&KVM_S390_VM_CPU_FEAT_NR_BITS);
    eval 'sub KVM_S390_VM_CPU_FEAT_ESOP () {0;}' unless defined(&KVM_S390_VM_CPU_FEAT_ESOP);
    eval 'sub KVM_S390_VM_CPU_FEAT_SIEF2 () {1;}' unless defined(&KVM_S390_VM_CPU_FEAT_SIEF2);
    eval 'sub KVM_S390_VM_CPU_FEAT_64BSCAO () {2;}' unless defined(&KVM_S390_VM_CPU_FEAT_64BSCAO);
    eval 'sub KVM_S390_VM_CPU_FEAT_SIIF () {3;}' unless defined(&KVM_S390_VM_CPU_FEAT_SIIF);
    eval 'sub KVM_S390_VM_CPU_FEAT_GPERE () {4;}' unless defined(&KVM_S390_VM_CPU_FEAT_GPERE);
    eval 'sub KVM_S390_VM_CPU_FEAT_GSLS () {5;}' unless defined(&KVM_S390_VM_CPU_FEAT_GSLS);
    eval 'sub KVM_S390_VM_CPU_FEAT_IB () {6;}' unless defined(&KVM_S390_VM_CPU_FEAT_IB);
    eval 'sub KVM_S390_VM_CPU_FEAT_CEI () {7;}' unless defined(&KVM_S390_VM_CPU_FEAT_CEI);
    eval 'sub KVM_S390_VM_CPU_FEAT_IBS () {8;}' unless defined(&KVM_S390_VM_CPU_FEAT_IBS);
    eval 'sub KVM_S390_VM_CPU_FEAT_SKEY () {9;}' unless defined(&KVM_S390_VM_CPU_FEAT_SKEY);
    eval 'sub KVM_S390_VM_CPU_FEAT_CMMA () {10;}' unless defined(&KVM_S390_VM_CPU_FEAT_CMMA);
    eval 'sub KVM_S390_VM_CPU_FEAT_PFMFI () {11;}' unless defined(&KVM_S390_VM_CPU_FEAT_PFMFI);
    eval 'sub KVM_S390_VM_CPU_FEAT_SIGPIF () {12;}' unless defined(&KVM_S390_VM_CPU_FEAT_SIGPIF);
    eval 'sub KVM_S390_VM_CPU_FEAT_KSS () {13;}' unless defined(&KVM_S390_VM_CPU_FEAT_KSS);
    eval 'sub KVM_S390_VM_CPU_PROCESSOR_SUBFUNC () {4;}' unless defined(&KVM_S390_VM_CPU_PROCESSOR_SUBFUNC);
    eval 'sub KVM_S390_VM_CPU_MACHINE_SUBFUNC () {5;}' unless defined(&KVM_S390_VM_CPU_MACHINE_SUBFUNC);
    eval 'sub KVM_S390_VM_CPU_PROCESSOR_UV_FEAT_GUEST () {6;}' unless defined(&KVM_S390_VM_CPU_PROCESSOR_UV_FEAT_GUEST);
    eval 'sub KVM_S390_VM_CPU_MACHINE_UV_FEAT_GUEST () {7;}' unless defined(&KVM_S390_VM_CPU_MACHINE_UV_FEAT_GUEST);
    eval 'sub KVM_S390_VM_CPU_UV_FEAT_NR_BITS () {64;}' unless defined(&KVM_S390_VM_CPU_UV_FEAT_NR_BITS);
    eval 'sub KVM_S390_VM_CRYPTO_ENABLE_AES_KW () {0;}' unless defined(&KVM_S390_VM_CRYPTO_ENABLE_AES_KW);
    eval 'sub KVM_S390_VM_CRYPTO_ENABLE_DEA_KW () {1;}' unless defined(&KVM_S390_VM_CRYPTO_ENABLE_DEA_KW);
    eval 'sub KVM_S390_VM_CRYPTO_DISABLE_AES_KW () {2;}' unless defined(&KVM_S390_VM_CRYPTO_DISABLE_AES_KW);
    eval 'sub KVM_S390_VM_CRYPTO_DISABLE_DEA_KW () {3;}' unless defined(&KVM_S390_VM_CRYPTO_DISABLE_DEA_KW);
    eval 'sub KVM_S390_VM_CRYPTO_ENABLE_APIE () {4;}' unless defined(&KVM_S390_VM_CRYPTO_ENABLE_APIE);
    eval 'sub KVM_S390_VM_CRYPTO_DISABLE_APIE () {5;}' unless defined(&KVM_S390_VM_CRYPTO_DISABLE_APIE);
    eval 'sub KVM_S390_VM_MIGRATION_STOP () {0;}' unless defined(&KVM_S390_VM_MIGRATION_STOP);
    eval 'sub KVM_S390_VM_MIGRATION_START () {1;}' unless defined(&KVM_S390_VM_MIGRATION_START);
    eval 'sub KVM_S390_VM_MIGRATION_STATUS () {2;}' unless defined(&KVM_S390_VM_MIGRATION_STATUS);
    eval 'sub KVM_GUESTDBG_USE_HW_BP () {0x10000;}' unless defined(&KVM_GUESTDBG_USE_HW_BP);
    eval 'sub KVM_HW_BP () {1;}' unless defined(&KVM_HW_BP);
    eval 'sub KVM_HW_WP_WRITE () {2;}' unless defined(&KVM_HW_WP_WRITE);
    eval 'sub KVM_SINGLESTEP () {4;}' unless defined(&KVM_SINGLESTEP);
    eval 'sub KVM_S390_PFAULT_TOKEN_INVALID () {0xffffffffffffffff;}' unless defined(&KVM_S390_PFAULT_TOKEN_INVALID);
    eval 'sub KVM_SYNC_PREFIX () {(1 << 0);}' unless defined(&KVM_SYNC_PREFIX);
    eval 'sub KVM_SYNC_GPRS () {(1 << 1);}' unless defined(&KVM_SYNC_GPRS);
    eval 'sub KVM_SYNC_ACRS () {(1 << 2);}' unless defined(&KVM_SYNC_ACRS);
    eval 'sub KVM_SYNC_CRS () {(1 << 3);}' unless defined(&KVM_SYNC_CRS);
    eval 'sub KVM_SYNC_ARCH0 () {(1 << 4);}' unless defined(&KVM_SYNC_ARCH0);
    eval 'sub KVM_SYNC_PFAULT () {(1 << 5);}' unless defined(&KVM_SYNC_PFAULT);
    eval 'sub KVM_SYNC_VRS () {(1 << 6);}' unless defined(&KVM_SYNC_VRS);
    eval 'sub KVM_SYNC_RICCB () {(1 << 7);}' unless defined(&KVM_SYNC_RICCB);
    eval 'sub KVM_SYNC_FPRS () {(1 << 8);}' unless defined(&KVM_SYNC_FPRS);
    eval 'sub KVM_SYNC_GSCB () {(1 << 9);}' unless defined(&KVM_SYNC_GSCB);
    eval 'sub KVM_SYNC_BPBC () {(1 << 10);}' unless defined(&KVM_SYNC_BPBC);
    eval 'sub KVM_SYNC_ETOKEN () {(1 << 11);}' unless defined(&KVM_SYNC_ETOKEN);
    eval 'sub KVM_SYNC_DIAG318 () {(1 << 12);}' unless defined(&KVM_SYNC_DIAG318);
    eval 'sub KVM_SYNC_S390_VALID_FIELDS () {( &KVM_SYNC_PREFIX |  &KVM_SYNC_GPRS |  &KVM_SYNC_ACRS |  &KVM_SYNC_CRS |  &KVM_SYNC_ARCH0 |  &KVM_SYNC_PFAULT |  &KVM_SYNC_VRS |  &KVM_SYNC_RICCB |  &KVM_SYNC_FPRS |  &KVM_SYNC_GSCB |  &KVM_SYNC_BPBC |  &KVM_SYNC_ETOKEN |  &KVM_SYNC_DIAG318);}' unless defined(&KVM_SYNC_S390_VALID_FIELDS);
    eval 'sub SDNXC () {8;}' unless defined(&SDNXC);
    eval 'sub SDNXL () {(1 <<  &SDNXC);}' unless defined(&SDNXL);
    eval 'sub KVM_REG_S390_TODPR () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U32 | 0x1);}' unless defined(&KVM_REG_S390_TODPR);
    eval 'sub KVM_REG_S390_EPOCHDIFF () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U64 | 0x2);}' unless defined(&KVM_REG_S390_EPOCHDIFF);
    eval 'sub KVM_REG_S390_CPU_TIMER () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U64 | 0x3);}' unless defined(&KVM_REG_S390_CPU_TIMER);
    eval 'sub KVM_REG_S390_CLOCK_COMP () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U64 | 0x4);}' unless defined(&KVM_REG_S390_CLOCK_COMP);
    eval 'sub KVM_REG_S390_PFTOKEN () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U64 | 0x5);}' unless defined(&KVM_REG_S390_PFTOKEN);
    eval 'sub KVM_REG_S390_PFCOMPARE () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U64 | 0x6);}' unless defined(&KVM_REG_S390_PFCOMPARE);
    eval 'sub KVM_REG_S390_PFSELECT () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U64 | 0x7);}' unless defined(&KVM_REG_S390_PFSELECT);
    eval 'sub KVM_REG_S390_PP () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U64 | 0x8);}' unless defined(&KVM_REG_S390_PP);
    eval 'sub KVM_REG_S390_GBEA () {( &KVM_REG_S390 |  &KVM_REG_SIZE_U64 | 0x9);}' unless defined(&KVM_REG_S390_GBEA);
}
1;
