require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__LINUX_KVM_RISCV_H)) {
    eval 'sub __LINUX_KVM_RISCV_H () {1;}' unless defined(&__LINUX_KVM_RISCV_H);
    unless(defined(&__ASSEMBLY__)) {
	require 'linux/types.ph';
	require 'asm/bitsperlong.ph';
	require 'asm/ptrace.ph';
	eval 'sub __KVM_HAVE_IRQ_LINE () {1;}' unless defined(&__KVM_HAVE_IRQ_LINE);
	eval 'sub KVM_COALESCED_MMIO_PAGE_OFFSET () {1;}' unless defined(&KVM_COALESCED_MMIO_PAGE_OFFSET);
	eval 'sub KVM_INTERRUPT_SET () {-1;}' unless defined(&KVM_INTERRUPT_SET);
	eval 'sub KVM_INTERRUPT_UNSET () {-2;}' unless defined(&KVM_INTERRUPT_UNSET);
	eval 'sub KVM_RISCV_MODE_S () {1;}' unless defined(&KVM_RISCV_MODE_S);
	eval 'sub KVM_RISCV_MODE_U () {0;}' unless defined(&KVM_RISCV_MODE_U);
	eval("sub KVM_RISCV_ISA_EXT_A () { 0; }") unless defined(&KVM_RISCV_ISA_EXT_A);
	eval("sub KVM_RISCV_ISA_EXT_C () { 1; }") unless defined(&KVM_RISCV_ISA_EXT_C);
	eval("sub KVM_RISCV_ISA_EXT_D () { 2; }") unless defined(&KVM_RISCV_ISA_EXT_D);
	eval("sub KVM_RISCV_ISA_EXT_F () { 3; }") unless defined(&KVM_RISCV_ISA_EXT_F);
	eval("sub KVM_RISCV_ISA_EXT_H () { 4; }") unless defined(&KVM_RISCV_ISA_EXT_H);
	eval("sub KVM_RISCV_ISA_EXT_I () { 5; }") unless defined(&KVM_RISCV_ISA_EXT_I);
	eval("sub KVM_RISCV_ISA_EXT_M () { 6; }") unless defined(&KVM_RISCV_ISA_EXT_M);
	eval("sub KVM_RISCV_ISA_EXT_SVPBMT () { 7; }") unless defined(&KVM_RISCV_ISA_EXT_SVPBMT);
	eval("sub KVM_RISCV_ISA_EXT_SSTC () { 8; }") unless defined(&KVM_RISCV_ISA_EXT_SSTC);
	eval("sub KVM_RISCV_ISA_EXT_SVINVAL () { 9; }") unless defined(&KVM_RISCV_ISA_EXT_SVINVAL);
	eval("sub KVM_RISCV_ISA_EXT_ZIHINTPAUSE () { 10; }") unless defined(&KVM_RISCV_ISA_EXT_ZIHINTPAUSE);
	eval("sub KVM_RISCV_ISA_EXT_ZICBOM () { 11; }") unless defined(&KVM_RISCV_ISA_EXT_ZICBOM);
	eval("sub KVM_RISCV_ISA_EXT_ZICBOZ () { 12; }") unless defined(&KVM_RISCV_ISA_EXT_ZICBOZ);
	eval("sub KVM_RISCV_ISA_EXT_ZBB () { 13; }") unless defined(&KVM_RISCV_ISA_EXT_ZBB);
	eval("sub KVM_RISCV_ISA_EXT_SSAIA () { 14; }") unless defined(&KVM_RISCV_ISA_EXT_SSAIA);
	eval("sub KVM_RISCV_ISA_EXT_V () { 15; }") unless defined(&KVM_RISCV_ISA_EXT_V);
	eval("sub KVM_RISCV_ISA_EXT_SVNAPOT () { 16; }") unless defined(&KVM_RISCV_ISA_EXT_SVNAPOT);
	eval("sub KVM_RISCV_ISA_EXT_ZBA () { 17; }") unless defined(&KVM_RISCV_ISA_EXT_ZBA);
	eval("sub KVM_RISCV_ISA_EXT_ZBS () { 18; }") unless defined(&KVM_RISCV_ISA_EXT_ZBS);
	eval("sub KVM_RISCV_ISA_EXT_ZICNTR () { 19; }") unless defined(&KVM_RISCV_ISA_EXT_ZICNTR);
	eval("sub KVM_RISCV_ISA_EXT_ZICSR () { 20; }") unless defined(&KVM_RISCV_ISA_EXT_ZICSR);
	eval("sub KVM_RISCV_ISA_EXT_ZIFENCEI () { 21; }") unless defined(&KVM_RISCV_ISA_EXT_ZIFENCEI);
	eval("sub KVM_RISCV_ISA_EXT_ZIHPM () { 22; }") unless defined(&KVM_RISCV_ISA_EXT_ZIHPM);
	eval("sub KVM_RISCV_ISA_EXT_SMSTATEEN () { 23; }") unless defined(&KVM_RISCV_ISA_EXT_SMSTATEEN);
	eval("sub KVM_RISCV_ISA_EXT_ZICOND () { 24; }") unless defined(&KVM_RISCV_ISA_EXT_ZICOND);
	eval("sub KVM_RISCV_ISA_EXT_ZBC () { 25; }") unless defined(&KVM_RISCV_ISA_EXT_ZBC);
	eval("sub KVM_RISCV_ISA_EXT_ZBKB () { 26; }") unless defined(&KVM_RISCV_ISA_EXT_ZBKB);
	eval("sub KVM_RISCV_ISA_EXT_ZBKC () { 27; }") unless defined(&KVM_RISCV_ISA_EXT_ZBKC);
	eval("sub KVM_RISCV_ISA_EXT_ZBKX () { 28; }") unless defined(&KVM_RISCV_ISA_EXT_ZBKX);
	eval("sub KVM_RISCV_ISA_EXT_ZKND () { 29; }") unless defined(&KVM_RISCV_ISA_EXT_ZKND);
	eval("sub KVM_RISCV_ISA_EXT_ZKNE () { 30; }") unless defined(&KVM_RISCV_ISA_EXT_ZKNE);
	eval("sub KVM_RISCV_ISA_EXT_ZKNH () { 31; }") unless defined(&KVM_RISCV_ISA_EXT_ZKNH);
	eval("sub KVM_RISCV_ISA_EXT_ZKR () { 32; }") unless defined(&KVM_RISCV_ISA_EXT_ZKR);
	eval("sub KVM_RISCV_ISA_EXT_ZKSED () { 33; }") unless defined(&KVM_RISCV_ISA_EXT_ZKSED);
	eval("sub KVM_RISCV_ISA_EXT_ZKSH () { 34; }") unless defined(&KVM_RISCV_ISA_EXT_ZKSH);
	eval("sub KVM_RISCV_ISA_EXT_ZKT () { 35; }") unless defined(&KVM_RISCV_ISA_EXT_ZKT);
	eval("sub KVM_RISCV_ISA_EXT_ZVBB () { 36; }") unless defined(&KVM_RISCV_ISA_EXT_ZVBB);
	eval("sub KVM_RISCV_ISA_EXT_ZVBC () { 37; }") unless defined(&KVM_RISCV_ISA_EXT_ZVBC);
	eval("sub KVM_RISCV_ISA_EXT_ZVKB () { 38; }") unless defined(&KVM_RISCV_ISA_EXT_ZVKB);
	eval("sub KVM_RISCV_ISA_EXT_ZVKG () { 39; }") unless defined(&KVM_RISCV_ISA_EXT_ZVKG);
	eval("sub KVM_RISCV_ISA_EXT_ZVKNED () { 40; }") unless defined(&KVM_RISCV_ISA_EXT_ZVKNED);
	eval("sub KVM_RISCV_ISA_EXT_ZVKNHA () { 41; }") unless defined(&KVM_RISCV_ISA_EXT_ZVKNHA);
	eval("sub KVM_RISCV_ISA_EXT_ZVKNHB () { 42; }") unless defined(&KVM_RISCV_ISA_EXT_ZVKNHB);
	eval("sub KVM_RISCV_ISA_EXT_ZVKSED () { 43; }") unless defined(&KVM_RISCV_ISA_EXT_ZVKSED);
	eval("sub KVM_RISCV_ISA_EXT_ZVKSH () { 44; }") unless defined(&KVM_RISCV_ISA_EXT_ZVKSH);
	eval("sub KVM_RISCV_ISA_EXT_ZVKT () { 45; }") unless defined(&KVM_RISCV_ISA_EXT_ZVKT);
	eval("sub KVM_RISCV_ISA_EXT_ZFH () { 46; }") unless defined(&KVM_RISCV_ISA_EXT_ZFH);
	eval("sub KVM_RISCV_ISA_EXT_ZFHMIN () { 47; }") unless defined(&KVM_RISCV_ISA_EXT_ZFHMIN);
	eval("sub KVM_RISCV_ISA_EXT_ZIHINTNTL () { 48; }") unless defined(&KVM_RISCV_ISA_EXT_ZIHINTNTL);
	eval("sub KVM_RISCV_ISA_EXT_ZVFH () { 49; }") unless defined(&KVM_RISCV_ISA_EXT_ZVFH);
	eval("sub KVM_RISCV_ISA_EXT_ZVFHMIN () { 50; }") unless defined(&KVM_RISCV_ISA_EXT_ZVFHMIN);
	eval("sub KVM_RISCV_ISA_EXT_ZFA () { 51; }") unless defined(&KVM_RISCV_ISA_EXT_ZFA);
	eval("sub KVM_RISCV_ISA_EXT_ZTSO () { 52; }") unless defined(&KVM_RISCV_ISA_EXT_ZTSO);
	eval("sub KVM_RISCV_ISA_EXT_ZACAS () { 53; }") unless defined(&KVM_RISCV_ISA_EXT_ZACAS);
	eval("sub KVM_RISCV_ISA_EXT_SSCOFPMF () { 54; }") unless defined(&KVM_RISCV_ISA_EXT_SSCOFPMF);
	eval("sub KVM_RISCV_ISA_EXT_ZIMOP () { 55; }") unless defined(&KVM_RISCV_ISA_EXT_ZIMOP);
	eval("sub KVM_RISCV_ISA_EXT_ZCA () { 56; }") unless defined(&KVM_RISCV_ISA_EXT_ZCA);
	eval("sub KVM_RISCV_ISA_EXT_ZCB () { 57; }") unless defined(&KVM_RISCV_ISA_EXT_ZCB);
	eval("sub KVM_RISCV_ISA_EXT_ZCD () { 58; }") unless defined(&KVM_RISCV_ISA_EXT_ZCD);
	eval("sub KVM_RISCV_ISA_EXT_ZCF () { 59; }") unless defined(&KVM_RISCV_ISA_EXT_ZCF);
	eval("sub KVM_RISCV_ISA_EXT_ZCMOP () { 60; }") unless defined(&KVM_RISCV_ISA_EXT_ZCMOP);
	eval("sub KVM_RISCV_ISA_EXT_ZAWRS () { 61; }") unless defined(&KVM_RISCV_ISA_EXT_ZAWRS);
	eval("sub KVM_RISCV_ISA_EXT_SMNPM () { 62; }") unless defined(&KVM_RISCV_ISA_EXT_SMNPM);
	eval("sub KVM_RISCV_ISA_EXT_SSNPM () { 63; }") unless defined(&KVM_RISCV_ISA_EXT_SSNPM);
	eval("sub KVM_RISCV_ISA_EXT_SVADE () { 64; }") unless defined(&KVM_RISCV_ISA_EXT_SVADE);
	eval("sub KVM_RISCV_ISA_EXT_SVADU () { 65; }") unless defined(&KVM_RISCV_ISA_EXT_SVADU);
	eval("sub KVM_RISCV_ISA_EXT_SVVPTC () { 66; }") unless defined(&KVM_RISCV_ISA_EXT_SVVPTC);
	eval("sub KVM_RISCV_ISA_EXT_ZABHA () { 67; }") unless defined(&KVM_RISCV_ISA_EXT_ZABHA);
	eval("sub KVM_RISCV_ISA_EXT_ZICCRSE () { 68; }") unless defined(&KVM_RISCV_ISA_EXT_ZICCRSE);
	eval("sub KVM_RISCV_ISA_EXT_ZAAMO () { 69; }") unless defined(&KVM_RISCV_ISA_EXT_ZAAMO);
	eval("sub KVM_RISCV_ISA_EXT_ZALRSC () { 70; }") unless defined(&KVM_RISCV_ISA_EXT_ZALRSC);
	eval("sub KVM_RISCV_ISA_EXT_MAX () { 71; }") unless defined(&KVM_RISCV_ISA_EXT_MAX);
	eval("sub KVM_RISCV_SBI_EXT_V01 () { 0; }") unless defined(&KVM_RISCV_SBI_EXT_V01);
	eval("sub KVM_RISCV_SBI_EXT_TIME () { 1; }") unless defined(&KVM_RISCV_SBI_EXT_TIME);
	eval("sub KVM_RISCV_SBI_EXT_IPI () { 2; }") unless defined(&KVM_RISCV_SBI_EXT_IPI);
	eval("sub KVM_RISCV_SBI_EXT_RFENCE () { 3; }") unless defined(&KVM_RISCV_SBI_EXT_RFENCE);
	eval("sub KVM_RISCV_SBI_EXT_SRST () { 4; }") unless defined(&KVM_RISCV_SBI_EXT_SRST);
	eval("sub KVM_RISCV_SBI_EXT_HSM () { 5; }") unless defined(&KVM_RISCV_SBI_EXT_HSM);
	eval("sub KVM_RISCV_SBI_EXT_PMU () { 6; }") unless defined(&KVM_RISCV_SBI_EXT_PMU);
	eval("sub KVM_RISCV_SBI_EXT_EXPERIMENTAL () { 7; }") unless defined(&KVM_RISCV_SBI_EXT_EXPERIMENTAL);
	eval("sub KVM_RISCV_SBI_EXT_VENDOR () { 8; }") unless defined(&KVM_RISCV_SBI_EXT_VENDOR);
	eval("sub KVM_RISCV_SBI_EXT_DBCN () { 9; }") unless defined(&KVM_RISCV_SBI_EXT_DBCN);
	eval("sub KVM_RISCV_SBI_EXT_STA () { 10; }") unless defined(&KVM_RISCV_SBI_EXT_STA);
	eval("sub KVM_RISCV_SBI_EXT_SUSP () { 11; }") unless defined(&KVM_RISCV_SBI_EXT_SUSP);
	eval("sub KVM_RISCV_SBI_EXT_MAX () { 12; }") unless defined(&KVM_RISCV_SBI_EXT_MAX);
	eval 'sub KVM_RISCV_TIMER_STATE_OFF () {0;}' unless defined(&KVM_RISCV_TIMER_STATE_OFF);
	eval 'sub KVM_RISCV_TIMER_STATE_ON () {1;}' unless defined(&KVM_RISCV_TIMER_STATE_ON);
	eval 'sub KVM_REG_RISCV_TYPE_MASK () {0xff000000;}' unless defined(&KVM_REG_RISCV_TYPE_MASK);
	eval 'sub KVM_REG_RISCV_TYPE_SHIFT () {24;}' unless defined(&KVM_REG_RISCV_TYPE_SHIFT);
	eval 'sub KVM_REG_RISCV_SUBTYPE_MASK () {0xff0000;}' unless defined(&KVM_REG_RISCV_SUBTYPE_MASK);
	eval 'sub KVM_REG_RISCV_SUBTYPE_SHIFT () {16;}' unless defined(&KVM_REG_RISCV_SUBTYPE_SHIFT);
	eval 'sub KVM_REG_RISCV_CONFIG () {(0x1 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_CONFIG);
	eval 'sub KVM_REG_RISCV_CONFIG_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct kvm_riscv_config\', $name) / $sizeof{\'unsigned long\'}));
	}' unless defined(&KVM_REG_RISCV_CONFIG_REG);
	eval 'sub KVM_REG_RISCV_CORE () {(0x2 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_CORE);
	eval 'sub KVM_REG_RISCV_CORE_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct kvm_riscv_core\', $name) / $sizeof{\'unsigned long\'}));
	}' unless defined(&KVM_REG_RISCV_CORE_REG);
	eval 'sub KVM_REG_RISCV_CSR () {(0x3 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_CSR);
	eval 'sub KVM_REG_RISCV_CSR_GENERAL () {(0x <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_CSR_GENERAL);
	eval 'sub KVM_REG_RISCV_CSR_AIA () {(0x1 <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_CSR_AIA);
	eval 'sub KVM_REG_RISCV_CSR_SMSTATEEN () {(0x2 <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_CSR_SMSTATEEN);
	eval 'sub KVM_REG_RISCV_CSR_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct kvm_riscv_csr\', $name) / $sizeof{\'unsigned long\'}));
	}' unless defined(&KVM_REG_RISCV_CSR_REG);
	eval 'sub KVM_REG_RISCV_CSR_AIA_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct kvm_riscv_aia_csr\', $name) / $sizeof{\'unsigned long\'}));
	}' unless defined(&KVM_REG_RISCV_CSR_AIA_REG);
	eval 'sub KVM_REG_RISCV_CSR_SMSTATEEN_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct kvm_riscv_smstateen_csr\', $name) / $sizeof{\'unsigned long\'}));
	}' unless defined(&KVM_REG_RISCV_CSR_SMSTATEEN_REG);
	eval 'sub KVM_REG_RISCV_TIMER () {(0x4 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_TIMER);
	eval 'sub KVM_REG_RISCV_TIMER_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct kvm_riscv_timer\', $name) / $sizeof{ &__u64}));
	}' unless defined(&KVM_REG_RISCV_TIMER_REG);
	eval 'sub KVM_REG_RISCV_FP_F () {(0x5 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_FP_F);
	eval 'sub KVM_REG_RISCV_FP_F_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct __riscv_f_ext_state\', $name) / $sizeof{ &__u32}));
	}' unless defined(&KVM_REG_RISCV_FP_F_REG);
	eval 'sub KVM_REG_RISCV_FP_D () {(0x6 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_FP_D);
	eval 'sub KVM_REG_RISCV_FP_D_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct __riscv_d_ext_state\', $name) / $sizeof{ &__u64}));
	}' unless defined(&KVM_REG_RISCV_FP_D_REG);
	eval 'sub KVM_REG_RISCV_ISA_EXT () {(0x7 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_ISA_EXT);
	eval 'sub KVM_REG_RISCV_ISA_SINGLE () {(0x <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_ISA_SINGLE);
	eval 'sub KVM_REG_RISCV_ISA_MULTI_EN () {(0x1 <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_ISA_MULTI_EN);
	eval 'sub KVM_REG_RISCV_ISA_MULTI_DIS () {(0x2 <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_ISA_MULTI_DIS);
	eval 'sub KVM_REG_RISCV_ISA_MULTI_REG {
	    my($__ext_id) = @_;
    	    eval q((($__ext_id) /  &__BITS_PER_LONG));
	}' unless defined(&KVM_REG_RISCV_ISA_MULTI_REG);
	eval 'sub KVM_REG_RISCV_ISA_MULTI_MASK {
	    my($__ext_id) = @_;
    	    eval q((1 << (($__ext_id) %  &__BITS_PER_LONG)));
	}' unless defined(&KVM_REG_RISCV_ISA_MULTI_MASK);
	eval 'sub KVM_REG_RISCV_ISA_MULTI_REG_LAST () { &KVM_REG_RISCV_ISA_MULTI_REG( &KVM_RISCV_ISA_EXT_MAX - 1);}' unless defined(&KVM_REG_RISCV_ISA_MULTI_REG_LAST);
	eval 'sub KVM_REG_RISCV_SBI_EXT () {(0x8 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_SBI_EXT);
	eval 'sub KVM_REG_RISCV_SBI_SINGLE () {(0x <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_SBI_SINGLE);
	eval 'sub KVM_REG_RISCV_SBI_MULTI_EN () {(0x1 <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_SBI_MULTI_EN);
	eval 'sub KVM_REG_RISCV_SBI_MULTI_DIS () {(0x2 <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_SBI_MULTI_DIS);
	eval 'sub KVM_REG_RISCV_SBI_MULTI_REG {
	    my($__ext_id) = @_;
    	    eval q((($__ext_id) /  &__BITS_PER_LONG));
	}' unless defined(&KVM_REG_RISCV_SBI_MULTI_REG);
	eval 'sub KVM_REG_RISCV_SBI_MULTI_MASK {
	    my($__ext_id) = @_;
    	    eval q((1 << (($__ext_id) %  &__BITS_PER_LONG)));
	}' unless defined(&KVM_REG_RISCV_SBI_MULTI_MASK);
	eval 'sub KVM_REG_RISCV_SBI_MULTI_REG_LAST () { &KVM_REG_RISCV_SBI_MULTI_REG( &KVM_RISCV_SBI_EXT_MAX - 1);}' unless defined(&KVM_REG_RISCV_SBI_MULTI_REG_LAST);
	eval 'sub KVM_REG_RISCV_VECTOR () {(0x9 <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_VECTOR);
	eval 'sub KVM_REG_RISCV_VECTOR_CSR_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct __riscv_v_ext_state\', $name) / $sizeof{\'unsigned long\'}));
	}' unless defined(&KVM_REG_RISCV_VECTOR_CSR_REG);
	eval 'sub KVM_REG_RISCV_VECTOR_REG {
	    my($n) = @_;
    	    eval q((($n) + $sizeof{\'struct __riscv_v_ext_state\'} / $sizeof{\'unsigned long\'}));
	}' unless defined(&KVM_REG_RISCV_VECTOR_REG);
	eval 'sub KVM_REG_RISCV_SBI_STATE () {(0xa <<  &KVM_REG_RISCV_TYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_SBI_STATE);
	eval 'sub KVM_REG_RISCV_SBI_STA () {(0x <<  &KVM_REG_RISCV_SUBTYPE_SHIFT);}' unless defined(&KVM_REG_RISCV_SBI_STA);
	eval 'sub KVM_REG_RISCV_SBI_STA_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct kvm_riscv_sbi_sta\', $name) / $sizeof{\'unsigned long\'}));
	}' unless defined(&KVM_REG_RISCV_SBI_STA_REG);
	eval 'sub KVM_DEV_RISCV_APLIC_ALIGN () {0x1000;}' unless defined(&KVM_DEV_RISCV_APLIC_ALIGN);
	eval 'sub KVM_DEV_RISCV_APLIC_SIZE () {0x4000;}' unless defined(&KVM_DEV_RISCV_APLIC_SIZE);
	eval 'sub KVM_DEV_RISCV_APLIC_MAX_HARTS () {0x4000;}' unless defined(&KVM_DEV_RISCV_APLIC_MAX_HARTS);
	eval 'sub KVM_DEV_RISCV_IMSIC_ALIGN () {0x1000;}' unless defined(&KVM_DEV_RISCV_IMSIC_ALIGN);
	eval 'sub KVM_DEV_RISCV_IMSIC_SIZE () {0x1000;}' unless defined(&KVM_DEV_RISCV_IMSIC_SIZE);
	eval 'sub KVM_DEV_RISCV_AIA_GRP_CONFIG () {0;}' unless defined(&KVM_DEV_RISCV_AIA_GRP_CONFIG);
	eval 'sub KVM_DEV_RISCV_AIA_CONFIG_MODE () {0;}' unless defined(&KVM_DEV_RISCV_AIA_CONFIG_MODE);
	eval 'sub KVM_DEV_RISCV_AIA_CONFIG_IDS () {1;}' unless defined(&KVM_DEV_RISCV_AIA_CONFIG_IDS);
	eval 'sub KVM_DEV_RISCV_AIA_CONFIG_SRCS () {2;}' unless defined(&KVM_DEV_RISCV_AIA_CONFIG_SRCS);
	eval 'sub KVM_DEV_RISCV_AIA_CONFIG_GROUP_BITS () {3;}' unless defined(&KVM_DEV_RISCV_AIA_CONFIG_GROUP_BITS);
	eval 'sub KVM_DEV_RISCV_AIA_CONFIG_GROUP_SHIFT () {4;}' unless defined(&KVM_DEV_RISCV_AIA_CONFIG_GROUP_SHIFT);
	eval 'sub KVM_DEV_RISCV_AIA_CONFIG_HART_BITS () {5;}' unless defined(&KVM_DEV_RISCV_AIA_CONFIG_HART_BITS);
	eval 'sub KVM_DEV_RISCV_AIA_CONFIG_GUEST_BITS () {6;}' unless defined(&KVM_DEV_RISCV_AIA_CONFIG_GUEST_BITS);
	eval 'sub KVM_DEV_RISCV_AIA_MODE_EMUL () {0;}' unless defined(&KVM_DEV_RISCV_AIA_MODE_EMUL);
	eval 'sub KVM_DEV_RISCV_AIA_MODE_HWACCEL () {1;}' unless defined(&KVM_DEV_RISCV_AIA_MODE_HWACCEL);
	eval 'sub KVM_DEV_RISCV_AIA_MODE_AUTO () {2;}' unless defined(&KVM_DEV_RISCV_AIA_MODE_AUTO);
	eval 'sub KVM_DEV_RISCV_AIA_IDS_MIN () {63;}' unless defined(&KVM_DEV_RISCV_AIA_IDS_MIN);
	eval 'sub KVM_DEV_RISCV_AIA_IDS_MAX () {2048;}' unless defined(&KVM_DEV_RISCV_AIA_IDS_MAX);
	eval 'sub KVM_DEV_RISCV_AIA_SRCS_MAX () {1024;}' unless defined(&KVM_DEV_RISCV_AIA_SRCS_MAX);
	eval 'sub KVM_DEV_RISCV_AIA_GROUP_BITS_MAX () {8;}' unless defined(&KVM_DEV_RISCV_AIA_GROUP_BITS_MAX);
	eval 'sub KVM_DEV_RISCV_AIA_GROUP_SHIFT_MIN () {24;}' unless defined(&KVM_DEV_RISCV_AIA_GROUP_SHIFT_MIN);
	eval 'sub KVM_DEV_RISCV_AIA_GROUP_SHIFT_MAX () {56;}' unless defined(&KVM_DEV_RISCV_AIA_GROUP_SHIFT_MAX);
	eval 'sub KVM_DEV_RISCV_AIA_HART_BITS_MAX () {16;}' unless defined(&KVM_DEV_RISCV_AIA_HART_BITS_MAX);
	eval 'sub KVM_DEV_RISCV_AIA_GUEST_BITS_MAX () {8;}' unless defined(&KVM_DEV_RISCV_AIA_GUEST_BITS_MAX);
	eval 'sub KVM_DEV_RISCV_AIA_GRP_ADDR () {1;}' unless defined(&KVM_DEV_RISCV_AIA_GRP_ADDR);
	eval 'sub KVM_DEV_RISCV_AIA_ADDR_APLIC () {0;}' unless defined(&KVM_DEV_RISCV_AIA_ADDR_APLIC);
	eval 'sub KVM_DEV_RISCV_AIA_ADDR_IMSIC {
	    my($__vcpu) = @_;
    	    eval q((1+ ($__vcpu)));
	}' unless defined(&KVM_DEV_RISCV_AIA_ADDR_IMSIC);
	eval 'sub KVM_DEV_RISCV_AIA_ADDR_MAX () {(1+  &KVM_DEV_RISCV_APLIC_MAX_HARTS);}' unless defined(&KVM_DEV_RISCV_AIA_ADDR_MAX);
	eval 'sub KVM_DEV_RISCV_AIA_GRP_CTRL () {2;}' unless defined(&KVM_DEV_RISCV_AIA_GRP_CTRL);
	eval 'sub KVM_DEV_RISCV_AIA_CTRL_INIT () {0;}' unless defined(&KVM_DEV_RISCV_AIA_CTRL_INIT);
	eval 'sub KVM_DEV_RISCV_AIA_GRP_APLIC () {3;}' unless defined(&KVM_DEV_RISCV_AIA_GRP_APLIC);
	eval 'sub KVM_DEV_RISCV_AIA_GRP_IMSIC () {4;}' unless defined(&KVM_DEV_RISCV_AIA_GRP_IMSIC);
	eval 'sub KVM_DEV_RISCV_AIA_IMSIC_ISEL_BITS () {12;}' unless defined(&KVM_DEV_RISCV_AIA_IMSIC_ISEL_BITS);
	eval 'sub KVM_DEV_RISCV_AIA_IMSIC_ISEL_MASK () {((1 <<  &KVM_DEV_RISCV_AIA_IMSIC_ISEL_BITS) - 1);}' unless defined(&KVM_DEV_RISCV_AIA_IMSIC_ISEL_MASK);
	eval 'sub KVM_DEV_RISCV_AIA_IMSIC_MKATTR {
	    my($__vcpu, $__isel) = @_;
    	    eval q(((($__vcpu) <<  &KVM_DEV_RISCV_AIA_IMSIC_ISEL_BITS) | (($__isel) &  &KVM_DEV_RISCV_AIA_IMSIC_ISEL_MASK)));
	}' unless defined(&KVM_DEV_RISCV_AIA_IMSIC_MKATTR);
	eval 'sub KVM_DEV_RISCV_AIA_IMSIC_GET_ISEL {
	    my($__attr) = @_;
    	    eval q((($__attr) &  &KVM_DEV_RISCV_AIA_IMSIC_ISEL_MASK));
	}' unless defined(&KVM_DEV_RISCV_AIA_IMSIC_GET_ISEL);
	eval 'sub KVM_DEV_RISCV_AIA_IMSIC_GET_VCPU {
	    my($__attr) = @_;
    	    eval q((($__attr) >>  &KVM_DEV_RISCV_AIA_IMSIC_ISEL_BITS));
	}' unless defined(&KVM_DEV_RISCV_AIA_IMSIC_GET_VCPU);
	eval 'sub KVM_NR_IRQCHIPS () {1;}' unless defined(&KVM_NR_IRQCHIPS);
    }
}
1;
